#!/bin/sh

if [ `whoami` != root ]; then
echo "Must be run as root!"
else

VERSION=`uname -r`

CURDIR=`pwd`

VER=`uname -r | sed 's/-.*//'`

cd /usr/src
if [ -f "linux-source-$VER/linux-source-$VER.tar.bz2" ]; then
  #Maverick bug
  cd linux-source-$VER
elif [ -d "linux-source-$VER/linux-source-$VER" ]; then
  #Maverick bug
  cd linux-source-$VER
fi

if [ -f "linux-source-$VER.tar.bz2" ]; then
echo "Cleaning up..."
rm -r linux-source-$VER > /dev/null
rm linux-source-$VER.tar > /dev/null

echo "Unpacking linux kernel source..."
bunzip2 linux-source-$VER.tar.bz2
tar xvf linux-source-$VER.tar

echo "Copying Module.symvers from headers..."
cp /usr/src/linux-headers-$VERSION/Module.symvers linux-source-$VER
cd linux-source-$VER

echo "Configuring..."
make oldconfig && make prepare

echo "Building scripts..."
make M=scripts

else
cd linux-source-$VER
fi

if grep -q "a >= 0xd0002" include/linux/hid.h ; then
  echo "hid.h is already fine."
else
  sed -i 's/#define IS_INPUT_APPLICATION.*/#define IS_INPUT_APPLICATION(a) (((a >= 0x00010000) \&\& (a <= 0x00010008)) || (a == 0x00010080) || (a == 0x000c0001) || (a == 0x000d0002) || (a >= 0xd0002 \&\& a <= 0xd0006))/' include/linux/hid.h
  echo "Modified hid.h."
fi

cd drivers/hid

if grep -q "EGALAX_MULTITOUCH" hid-core.c ; then
  echo "hid-core.c is already fine."
else
  sed -i 's/{ HID_USB_DEVICE(USB_VENDOR_ID_ZEROPLUS, 0x0030) },/{ HID_USB_DEVICE(USB_VENDOR_ID_ZEROPLUS, 0x0030) },\n\t{ HID_USB_DEVICE(USB_VENDOR_ID_DWAV, USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH) },/' hid-core.c
  echo "Modified hid-core.c."
fi

if grep -q "EGALAX_MULTITOUCH" usbhid/hid-quirks.c ; then
  sed -i 's/{ USB_VENDOR_ID_DWAV, USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH, HID_QUIRK_MULTI_INPUT },//' usbhid/hid-quirks.c
  echo "Modified hid-quirks.c."
else
  echo "hid-quirks.c is already fine."
fi


if grep -q "0x0eef" hid-ids.h ; then
  echo "hid-ids.h is already fine."
else
  echo "#define USB_VENDOR_ID_DWAV		0x0eef" >> hid-ids.h
  echo "#define USB_DEVICE_ID_DWAV_EGALAX_MULTITOUCH	0x480d" >> hid-ids.h
  echo "Modified hid-ids.h."
fi

if grep -q "hid-egalax" Makefile ; then
  echo "Makefile is already fine."
else
  echo "obj-m += hid-egalax.o" >> Makefile
fi

cp $CURDIR/hid-egalax.c .

echo "Building modules..."
make -C ../.. SUBDIRS=`pwd` modules

echo "Copying..."
rm -r $CURDIR/../egalax-driver-deb/deb/lib/modules/*
mkdir $CURDIR/../egalax-driver-deb/deb/lib/modules/$VERSION
mkdir $CURDIR/../egalax-driver-deb/deb/lib/modules/$VERSION/updates
mkdir $CURDIR/../egalax-driver-deb/deb/lib/modules/$VERSION/updates/hid-egalax
mkdir $CURDIR/../egalax-driver-deb/deb/lib/modules/$VERSION/updates/hid-egalax/usbhid

cp hid.ko $CURDIR/../egalax-driver-deb/deb/lib/modules/$VERSION/updates/hid-egalax
cp hid-egalax.ko $CURDIR/../egalax-driver-deb/deb/lib/modules/$VERSION/updates/hid-egalax
cp usbhid/usbhid.ko $CURDIR/../egalax-driver-deb/deb/lib/modules/$VERSION/updates/hid-egalax/usbhid

echo "Should have built. Ready to build deb."

fi
